import json, os
from pathlib import Path

DB_PATH = "/var/lib/fempkg/db.json"
Path(os.path.dirname(DB_PATH)).mkdir(parents=True, exist_ok=True)

def load_db():
    if os.path.exists(DB_PATH):
        with open(DB_PATH, "r") as f:
            return json.load(f)
    return {"installed": {}}

def save_db(db):
    with open(DB_PATH, "w") as f:
        json.dump(db, f, indent=2)

def register_package(name, version, db=None):
    if db is None:
        db = load_db()
    db["installed"][name] = version
    save_db(db)
    print(f"Registered: {name}-{version}")

def is_installed(name, version=None, db=None):
    if db is None:
        db = load_db()
    installed_ver = db["installed"].get(name)
    if installed_ver is None:
        return False
    if version:
        return installed_ver == version
    return True

