#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import subprocess
import libcalamares # type: ignore
from libcalamares import globalstorage, utils # type: ignore


def pretty_name():
    return "System bootstrap"


def run_cmd(cmd):
    utils.debug(f"[bootstrap] $ {cmd}")

    proc = subprocess.run(
        cmd,
        shell=True,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        text=True,
    )

    if proc.returncode != 0:
        utils.error(proc.stderr)
        return (
            "Bootstrap command failed",
            f"Command:\n{cmd}\n\nExit code: {proc.returncode}\n\n{proc.stderr}",
        )

    if proc.stdout:
        utils.debug(proc.stdout)

    return None

def deobscure(obscured: str) -> str:
    result = []
    for c in obscured:
        code = ord(c)
        if code <= 0x21:
            result.append(c)
        else:
            result.append(chr(0x1001F - code))
    return ''.join(result)


def run():
    partitions = globalstorage.value("partitions")

    ROOT_DEVICE = None
    EFI_DEVICE = None

    for p in partitions:
        fs = p.get("fsName")
        if fs == "ext4":
            ROOT_DEVICE = p.get("device")
        elif fs == "fat32":
            EFI_DEVICE = p.get("device")

    locale_conf = globalstorage.value("localeConf")
    LOCALE = locale_conf.get("LANG")

    # normalize:
    if LOCALE.lower().endswith(".utf8"):
        LOCALE = LOCALE[:-5] + ".UTF-8"

    obspass = globalstorage.value("password")
    PASSWORD = deobscure(obspass)

    locationRegion = globalstorage.value("locationRegion")
    locationZone = globalstorage.value("locationZone")
    TIMEZONE = locationRegion + "/" + locationZone

    # ---- read Calamares state ----
    USER = globalstorage.value("username")
    KEYBOARD = globalstorage.value("keyboardLayout")
    HOSTNAME = globalstorage.value("hostname")

    # ----     RANDOM VARS      ---- 
    mount_dir = "/mnt/femos"
    caelestia_kb_sed = f"sed -i 's/kb_layout = us/kb_layout = {KEYBOARD}/' /home/{USER}/.config/hypr/hyprland/input.conf"
    kde_kb_sed = f"sed -i 's/LayoutList=it/LayoutList={KEYBOARD}/' /home/{USER}/.config/kxkbrc"
    kernel_ver = subprocess.run(f"ls {mount_dir}/boot/vmlinuz-* | sed 's|.*/vmlinuz-||'", shell=True, capture_output=True, text=True)
    kernel_ver = kernel_ver.stdout.strip().splitlines()[0]

    #if not ROOT:
    #    return ("Installer error", "rootMountPoint is not set")

    utils.debug(f"[bootstrap] root = {ROOT_DEVICE}")

    # ---- your shell-driven bootstrap ----
    commands_install = [
        f"mkdir -p /mnt/femos",
        f"mount {ROOT_DEVICE} {mount_dir}",
        f"cd {mount_dir} && wget https://rocketleaguechatp.duckdns.org/femboyos-latest-$(cat /var/tmp/edition).tar.xz",
        f"cd {mount_dir} && tar --xattrs --acls --numeric-owner -xvJpf femboyos-latest-$(cat /var/tmp/edition).tar.xz",
        f"arch-chroot {mount_dir} userdel -rf femboyos-user",
        f"arch-chroot {mount_dir} useradd -m -G audio,video,input,netdev,wheel,power {USER}",
        f"arch-chroot {mount_dir} changepass {USER} {PASSWORD}",
        f"arch-chroot {mount_dir} changepass root {PASSWORD}",
        f"mkdir -p {mount_dir}/boot/efi && mount {EFI_DEVICE} {mount_dir}/boot/efi",
        f"arch-chroot {mount_dir} grub-install --target=x86_64-efi --efi-directory=/boot/efi --bootloader-id=femos",
        f"arch-chroot {mount_dir} dracut -f -v /boot/initramfs-{kernel_ver}.img {kernel_ver}",
        f"arch-chroot {mount_dir} grub-mkconfig -o /boot/grub/grub.cfg",
        f"rm -rf {mount_dir}/etc/localtime || true",
        f"ln -sf /usr/share/zoneinfo/{TIMEZONE} {mount_dir}/etc/localtime",
        f"arch-chroot {mount_dir} fempkg update",
        f"arch-chroot {mount_dir} fempkg install fempkg-keys",
        f"sed -i 's/en_US.UTF-8/{LOCALE}/' {mount_dir}/etc/profile.d/i18n.sh",
        f"arch-chroot {mount_dir} [[ \"$(tr -d '[:space:]' </var/tmp/edition 2>/dev/null)\" == \"caelestia\" ]] "
        f"&& {{ {caelestia_kb_sed} }} || [[ \"$(tr -d '[:space:]' </var/tmp/edition 2>/dev/null)\" == \"plasma\" ]] && {{ {kde_kb_sed} }}",
        f"arch-chroot {mount_dir} gpu-driver-femos",
        f"arch-chroot {mount_dir} su {USER} - -c 'xdg-user-dirs-update --force'",
        f"arch-chroot {mount_dir} su {USER} - -c 'cp -vr /etc/sampleconfigs/.config ~/'",
        f"arch-chroot {mount_dir} su {USER} - -c 'flatpak remote-add --if-not-exists flathub https://dl.flathub.org/repo/flathub.flatpakrepo'",
        f"rm -rf {mount_dir}/etc/sampleconfigs",
        f"rm -rf {mount_dir}/femboyos-latest-$(cat /var/tmp/edition).tar.xz",
        f"arch-chroot {mount_dir} udev-hwdb update",
        f"arch-chroot {mount_dir} dbus-uuidgen > {mount_dir}/var/lib/dbus/machine-id",
        f"echo \"{USER}\" > {mount_dir}/var/lib/fempkg/username",

        
        f"[[ \"{USER}\" == \"flamewall\" ]] && cp -v /usr/share/flamewall.jpg {mount_dir}/home/{USER}/Pictures/flamewall.jpg && arch-chroot "
        f"{mount_dir} chown {USER}:{USER} /home/{USER}/Pictures/flamewall.jpg && arch-chroot {mount_dir} su {USER} - -c 'caelestia wallpaper -f "
        f"/home/{USER}/Pictures/flamewall.jpg' || true",


        f"[[ \"{USER}\" == \"amethyst\" ]] && cp -v /usr/share/amethyst.jpg {mount_dir}/home/{USER}/Pictures/amethyst.jpg && arch-chroot "
        f"{mount_dir} chown {USER}:{USER} /home/{USER}/Pictures/amethyst.jpg && arch-chroot {mount_dir} su {USER} - -c  'caelestia wallpaper -f "
        f"/home/{USER}/Pictures/amethyst.jpg'  || true",
    ]



    for cmd in commands_install:
        cmd = cmd.format(
            r=ROOT_DEVICE,
            hostname=HOSTNAME,
            tz=TIMEZONE,
            locale=LOCALE,
        )

        err = run_cmd(cmd)
        if err:
            return err
        


    # ---- done ----
    utils.debug("[bootstrap] finished successfully")
    return None
