pkgname =  "LVM2"
pkgver  = "2.03.35" 
source  = f"https://sourceware.org/ftp/lvm2/LVM2.{pkgver}.tgz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}.{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libaio"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}.{pkgver}.tgz",

    # 64-bit build
    f"cd {builddir} && PATH+=\\:/usr/sbin ./configure --prefix=/usr --enable-cmdlib --enable-pkgconfig --enable-udev_sync",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && rm -fv /usr/lib/udev/rules.d/69-dm-lvm.rules || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
