pkgname =  "Linux-PAM"
pkgver  = "1.7.1" 
source  = f"https://github.com/linux-pam/linux-pam/releases/download/v{pkgver}/Linux-PAM-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D docdir=/usr/share/doc/Linux-PAM-{pkgver}",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && chmod -v 4755 /usr/sbin/unix_chkpwd || true && rm -rf /usr/lib/systemd || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
