pkgname =  "NSPR"
pkgver  = "4.37" 
source  = f"https://archive.mozilla.org/pub/nspr/releases/v{pkgver}/src/nspr-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/nspr-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/nspr-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir}/nspr && sed -i '/^RELEASE/s|^|#|' pr/src/misc/Makefile.in && sed -i 's|$(LIBRARY) ||' config/rules.mk && ./configure --prefix=/usr --with-mozilla --with-pthreads $([ $(uname -m) = x86_64 ] && echo --enable-64bit)",
    f"cd {builddir}/nspr && make -j$(nproc)",
    f"cd {builddir}/nspr && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
