pkgname =  "NSS"
pkgver  = "3.117" 
source  = f"https://archive.mozilla.org/pub/security/nss/releases/NSS_3_117_RTM/src/nss-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/nss-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["NSPR", "p11-kit"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/nss-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/nss-standalone-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../nss-standalone-1.patch",
    f"cd {builddir}/nss && make BUILD_OPT=1 NSPR_INCLUDE_DIR=/usr/include/nspr USE_SYSTEM_ZLIB=1 ZLIB_LIBS=-lz NSS_ENABLE_WERROR=0 $([ $(uname -m) = x86_64 ] && echo USE_64=1) $([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1)",
    f"cd {builddir}/nss && cd ../dist && install -v -m755 Linux*/lib/*.so /usr/lib && install -v -m644 Linux*/lib/{{*.chk,libcrmf.a}} /usr/lib && install -v -m755 -d /usr/include/nss && cp -v -RL {{public,private}}/nss/* /usr/include/nss && install -v -m755 Linux*/bin/{{certutil,nss-config,pk12util}} /usr/bin && install -v -m644 Linux*/lib/pkgconfig/nss.pc /usr/lib/pkgconfig && ln -sfv ./pkcs11/p11-kit-trust.so /usr/lib/libnssckbi.so || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
