pkgname =  "NetworkManager"
pkgver  = "1.54.1" 
source  = f"https://gitlab.freedesktop.org/NetworkManager/NetworkManager/-/releases/{pkgver}/downloads/NetworkManager-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libndp", "curl", "dhcpcd", "iptables", "libpsl", "newt", "NSS", "polkit", "pygobject", "elogind", "vala", "wpa_supplicant"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && grep -rl '^#!.*python$' | xargs sed -i '1s/python/&3/' && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D libaudit=no -D nmtui=true -D ovs=false -D ppp=false -D nbft=false -D selinux=false -D session_tracking=elogind -D modem_manager=false -D systemdsystemunitdir=no -D systemd_journal=false -D nm_cloud_setup=false -D qt=false",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && mv -v /usr/share/doc/NetworkManager{{,-{pkgver}}} || true && for file in $(echo ../man/*.[1578]); do section=${{file##*.}} && install -vdm 755 /usr/share/man/man$section && install -vm 644 $file /usr/share/man/man$section/; done || true && cp -Rv ../docs/{{api,libnm}} /usr/share/doc/NetworkManager-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
