pkgname =  "accountsservice"
pkgver  = "23.13.9" 
source  = f"https://www.freedesktop.org/software/accountsservice/accountsservice-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["polkit", "glib", "elogind", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mv tests/dbusmock{{,-tests}}",
    f"cd {builddir} && sed -e '/accounts_service\.py/s/dbusmock/dbusmock-tests/' -e 's/assertEquals/assertEqual/' -i tests/test-libaccountsservice.py",
    f"cd {builddir} && sed -i '/^SIMULATED_SYSTEM_LOCALE/s/en_IE.UTF-8/en_HK.iso88591/' tests/test-daemon.py",
    f"cd {builddir} && mkdir -v build && cd build && meson setup .. --prefix=/usr --buildtype=release -D admin_group=adm -D elogind=true -D systemdsystemunitdir=no",
    f"cd {builddir}/build && grep 'print_indent' ../subprojects/mocklibc-1.0/src/netgroup.c | sed 's/ {{/;/' >> ../subprojects/mocklibc-1.0/src/netgroup.h && sed -i '1i#include <stdio.h>' ../subprojects/mocklibc-1.0/src/netgroup.h",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
