pkgname = "acl"
pkgver  = "2.3.2"
source  = f"https://download.savannah.gnu.org/releases/acl/acl-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/acl-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make check -j$(nproc) || true",
    f"cd {builddir} && make install",

    # 32-bit build
    f"cd {builddir} && make distclean",
    f"cd {builddir} && CC=\"gcc -m32\" ./configure --prefix=/usr --disable-static --libdir=/usr/lib32 --libexecdir=/usr/lib32 --host=i686-pc-linux-gnu",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make DESTDIR=$PWD/DESTDIR install",
    f"cd {builddir} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd {builddir} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
