pkgname =  "alsa-lib"
pkgver  = "1.2.14" 
source  = f"https://www.alsa-project.org/files/pub/lib/alsa-lib-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["elogind"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2 && wget https://www.alsa-project.org/files/pub/lib/alsa-ucm-conf-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && tar -C /usr/share/alsa --strip-components=1 -xf ../alsa-ucm-conf-{pkgver}.tar.bz2 || true && install -v -d -m755 /usr/share/doc/alsa-lib-{pkgver}/html/search || true && install -v -m644 doc/doxygen/html/*.* /usr/share/doc/alsa-lib-{pkgver}/html || true && install -v -m644 doc/doxygen/html/search/* /usr/share/doc/alsa-lib-{pkgver}/html/search || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
