pkgname =  "appstream"
pkgver  = "1.1.1" 
source  = f"https://www.freedesktop.org/software/appstream/releases/AppStream-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/AppStream-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["curl", "elogind", "itstool", "libxml2", "libxmlb", "libfyaml"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/AppStream-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D apidocs=false -D stemming=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && mv -v /usr/share/doc/appstream{{,-1.1.1}} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
