pkgname =  "atspi2core"
pkgver  = "2.58.1" 
source  = f"https://download.gnome.org/sources/at-spi2-core/2.58/at-spi2-core-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/at-spi2-core-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["dbus", "glib", "gsettings-desktop-schemas", "xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/at-spi2-core-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D gtk2_atk_adaptor=false -D systemd_user_dir=/tmp",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm /tmp/at-spi-dbus-bus.service",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
