# attr.recipe.py
pkgname = "attr"
pkgver  = "2.5.2"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --sysconfdir=/etc --docdir=/usr/share/doc/attr-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make check -j$(nproc) || true",
    f"cd /sources/{pkgname}-{pkgver} && make install",

    # 32 bit

    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" ./configure --prefix=/usr --disable-static --sysconfdir=/etc --libdir=/usr/lib32 --host=i686-pc-linux-gnu",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
