pkgname  = "aubio" # so i made this myself tho i just used gpt to tidy this recipe as it looked. interesting to say the least
pkgver   = "0.4.9"
source   = f"https://gitlab.archlinux.org/archlinux/packaging/packages/{pkgname}.git"
builddir = f"/tmp/fempkgbuild/{pkgname}"
source_type = "git"
deps = ["ffmpeg", "depot_tools"]  # depot_tools provides vpython3 (Python 3.8)

build = [

    # Fetch source tarball + patches
    f"""
    cd {builddir} &&
    wget https://aubio.org/pub/aubio-{pkgver}.tar.bz2 &&
    tar -xvf aubio-{pkgver}.tar.bz2 &&
    wget -O python-aubio-{pkgver}-ffmpeg5.patch \
      https://github.com/aubio/aubio/commit/8a05420e5dd8c7b8b2447f82dc919765876511b3.patch &&
    wget https://github.com/aubio/aubio/commit/cdfe9cef.patch &&
    wget https://github.com/aubio/aubio/commit/245deead.patch &&
    wget https://github.com/aubio/aubio/commit/0b947f96.patch &&
    wget https://github.com/aubio/aubio/commit/53bc55cd.patch
    """,

    # Apply patches
    f"""
    cd {builddir}/aubio-{pkgver} &&
    patch -Np1 -i ../python-aubio-{pkgver}-ffmpeg5.patch &&
    patch -Np1 -i ../cdfe9cef.patch &&
    patch -Np1 -i ../245deead.patch &&
    patch -Np1 -i ../0b947f96.patch &&
    patch -Np1 -i ../53bc55cd.patch &&
    patch -Np1 -i ../ffmpeg7.patch &&
    sed -i 's#AV_INPUT_BUFFER_MIN_SIZE#16384#' src/io/source_avcodec.c &&
    patch -Np1 -i ../numpy-2.0.patch
    """,

    # Configure
    f"""
    cd {builddir}/aubio-{pkgver} &&
    vpython3 ./waf configure --alltests --enable-fftw3 \
      --libdir=/usr/lib --prefix=/usr
    """,

    # Build
    f"cd {builddir}/aubio-{pkgver} && vpython3 ./waf build",

    # Python wheel (optional but you had it)
    f"""
    cd {builddir}/aubio-{pkgver} &&
    CFLAGS+=" -Wno-incompatible-pointer-types" \
      python3 -m build --wheel --no-isolation
    """,

    # Install
    f"""
    cd {builddir}/aubio-{pkgver} &&
    vpython3 ./waf --destdir=$PWD/_pkg install &&
    cp -rv _pkg/* /
    """,

    # Cleanup
    f"rm -rf {builddir}"
]