pkgname =  "avahi"
pkgver  = "0.8" 
source  = f"https://github.com/lathiat/avahi/releases/download/v{pkgver}/avahi-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "gtk3", "libdaemon"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/avahi-{pkgver}-ipv6_race_condition_fix-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../avahi-{pkgver}-ipv6_race_condition_fix-1.patch && ./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var --disable-static --disable-libevent --disable-mono --disable-monodoc --disable-python --disable-qt3 --disable-qt4 --disable-qt5 --enable-core-docs --with-distro=none --with-systemdsystemunitdir=no --with-dbus-system-address='unix:path=/run/dbus/system_bus_socket'",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
