# binutils.recipe.py
pkgname = "binutils"
pkgver  = "2.45"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && mkdir -v build",
    f"cd /sources/{pkgname}-{pkgver}/build && ../configure --prefix=/usr --sysconfdir=/etc --enable-ld=default --enable-plugins --enable-shared --disable-werror --enable-64-bit-bfd --enable-new-dtags --with-system-zlib --enable-default-hash-style=gnu",
    f"cd /sources/{pkgname}-{pkgver}/build && make tooldir=/usr -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver}/build && make -k check -j$(nproc) || true",
    f"cd /sources/{pkgname}-{pkgver}/build && make tooldir=/usr install",
    f"cd /sources/{pkgname}-{pkgver}/build && rm -rfv /usr/lib/lib{{bfd,ctf,ctf-nobfd,gprofng,opcodes,sframe}}.a /usr/share/doc/gprofng/",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
