pkgname =  "bluez"
pkgver  = "5.84"
source  = f"https://www.kernel.org/pub/linux/bluetooth/bluez-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["dbus", "glib", "libical"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var --enable-library --disable-manpages --disable-systemd",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && ln -svf ../libexec/bluetooth/bluetoothd /usr/sbin || true && install -v -dm755 /etc/bluetooth || true && install -v -m644 src/main.conf /etc/bluetooth/main.conf || true && install -m644 ./obexd/src/org.bluez.obex.service /usr/share/dbus-1/services || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
