pkgname =  "brotli"
pkgver  = "1.1.0" 
source  = f"https://github.com/google/brotli/archive/v{pkgver}/brotli-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",
    f"cd {builddir} && sed \"/c\\/.*\\.[ch]'/d; /include_dirs=\\[/ i libraries=['brotlicommon','brotlidec','brotlienc'],\" -i setup.py",
    f"cd {builddir} && pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --no-user Brotli",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
