# Bzip.recipe.py
pkgname = "bzip2"
pkgver  = "1.0.8"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # Patch Makefile for clean install
    f"cd /sources/{pkgname}-{pkgver} && patch -Np1 -i ../bzip2-{pkgver}-install_docs-1.patch",
    f"cd /sources/{pkgname}-{pkgver} && sed -i 's@\(ln -s -f \)$(PREFIX)/bin/@\\1@' Makefile",
    f"cd /sources/{pkgname}-{pkgver} && sed -i 's@(PREFIX)/man@(PREFIX)/share/man@g' Makefile",

    # --- Build 64-bit shared library ---
    f"cd /sources/{pkgname}-{pkgver} && make -f Makefile-libbz2_so -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make clean",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",

    # --- Manual 64-bit install ---
    f"cd /sources/{pkgname}-{pkgver} && install -Dm755 bzip2 /usr/bin/bzip2",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf bzip2 /usr/bin/bunzip2",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf bzip2 /usr/bin/bzcat",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm755 bzip2recover /usr/bin/bzip2recover",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm644 bzip2.1 /usr/share/man/man1/bzip2.1",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm644 bzlib.h /usr/include/",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm644 libbz2.a /usr/lib/",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm755 bzgrep /usr/bin/bzgrep",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf bzgrep /usr/bin/bzegrep",
    f"rm -fv /usr/lib/libbz2.a",

    # --- Build 32-bit library ---
    f"cd /sources/{pkgname}-{pkgver} && make clean",
    f"cd /sources/{pkgname}-{pkgver} && sed -i 's/^CC=.*/CC=gcc -m32/' Makefile Makefile-libbz2_so",
    f"cd /sources/{pkgname}-{pkgver} && make -f Makefile-libbz2_so -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make libbz2.a -j$(nproc)",

    # --- Manual 32-bit install ---
    f"cd /sources/{pkgname}-{pkgver} && install -Dm755 libbz2.so.{pkgver} /usr/lib32/libbz2.so.{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf libbz2.so.1.0.8 /usr/lib32/libbz2.so",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf libbz2.so.1.0.8 /usr/lib32/libbz2.so.1",
    f"cd /sources/{pkgname}-{pkgver} && ln -sf libbz2.so.1.0.8 /usr/lib32/libbz2.so.1.0",
    f"cd /sources/{pkgname}-{pkgver} && install -Dm644 libbz2.a /usr/lib32/libbz2.a",

    # Clean source
    f"rm -rf /sources/{pkgname}-{pkgver}",
]
