pkgname = "caelestia"
pkgver  = "1.0"
source  = "https://github.com/caelestia-dots/caelestia.git"
source_type = "git"
builddir = f"/tmp/fempkgbuild/{pkgname}"
deps = [
    "caelestia-shell", "inotify-tools", "hyprland",
    "xdg-desktop-portal-hyprland", "xdg-desktop-portal", "hyprpicker",
    "cliphist", "btop", "fish", "fastfetch", "starship", "eza",
    "qt6ct", "papirus-icon-theme", "adw-gtk3-theme"
]

# Read the username from /var/lib/fempkg/username
with open("/var/lib/fempkg/username") as f:
    username = f.read().strip()

build = [

    # Make sure the target directory exists
    f"su {username} -c 'mkdir -p ~/.local/share/caelestia'",

    # If repo exists, just git pull; otherwise clone it
    f"su {username} -c 'if [ -d ~/.local/share/caelestia/.git ]; "
    "then cd ~/.local/share/caelestia && git pull; "
    "else git clone {source} ~/.local/share/caelestia; fi'",
    f"su {username} -c 'sed -i.bak \"s/^\\s*utc_time_offset\\s*=\\s*\\\"local\\\"/utc_time_offset = \\\"+2\\\"/\" ~/.config/starship.toml' && sed -i '/^bind = Super+Shift, S, global, caelestia:screenshotFreeze/d' ~/.config/hypr/hyprland/keybinds.conf"

    # Cleanup builddir (optional)
    f"rm -rf {builddir}"
]
