pkgname =  "cargo-c"
pkgver  = "0.10.16" 
source  = f"https://github.com/lu-zero/cargo-c/archive/v{pkgver}/cargo-c-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["rustc", "libssh2"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && cd {builddir} && curl -fLO https://github.com/lu-zero/cargo-c/releases/download/v{pkgver}/Cargo.lock",

    # 64-bit build
    f"cd {builddir} && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && cargo build --release",
    f"cd {builddir} && install -vm755 target/release/cargo-{{capi,cbuild,cinstall,ctest}} /usr/bin/ || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
