pkgname =  "cdrdao"
pkgver  = "1.2.5" 
source  = f"https://downloads.sourceforge.net/cdrdao/cdrdao-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --mandir=/usr/share/man && make CC=\"gcc -std=gnu17\"",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && install -v -m755 -d /usr/share/doc/cdrdao-{pkgver} && install -v -m644 README /usr/share/doc/cdrdao-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
