pkgname =  "cdrtools"
pkgver  = "3.02a09" 
source  = f"https://downloads.sourceforge.net/cdrtools/cdrtools-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/cdrtools/cdrtools-3.02/"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["alsa-lib"]

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"""cd {builddir} &&
sed -i 's|/opt/schily|/usr|g' DEFAULTS/Defaults.linux &&
sed -i 's|DEFINSGRP=.*|DEFINSGRP=root|' DEFAULTS/Defaults.linux &&
sed -i 's|INSDIR=\\s*sbin|INSDIR=bin|' rscsi/Makefile &&

export GMAKE_NOWARN=true &&
export CFLAGS="$CFLAGS -std=gnu89 -fno-strict-aliasing" &&

make -j1 INS_BASE=/usr \\
     DEFINSUSR=root \\
     DEFINSGRP=root \\
     VERSION_OS="FemboyOS"
""",

    f"""cd {builddir} &&
make INS_BASE=/usr \\
     DEFINSUSR=root \\
     DEFINSGRP=root \\
     MANSUFF_LIB=3cdr \\
     install &&

install -v -d -m755 /usr/share/doc/cdrtools-{pkgver} &&
install -v -m644 README.* READMEs/* ABOUT doc/*.ps /usr/share/doc/cdrtools-{pkgver}
""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
