pkgname = "coreutils"
pkgver  = "9.8" 
source  = f"https://ftpmirror.gnu.org//gnu/coreutils/coreutils-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/lfs/development/coreutils-{pkgver}-i18n-2.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../coreutils-{pkgver}-i18n-2.patch",
    f"cd {builddir} && autoreconf -fv && automake -af && FORCE_UNSAFE_CONFIGURE=1 ./configure --prefix=/usr --enable-no-install-program=kill,uptime",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",
    f"cd {builddir} && mv -v /usr/bin/chroot /usr/sbin || true",
    f"cd {builddir} && mv -v /usr/share/man/man1/chroot.1 /usr/share/man/man8/chroot.8 || true",
    f"cd {builddir} && sed -i 's/\"1\"/\"8\"/' /usr/share/man/man8/chroot.8 || true",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
