pkgname =  "cpio"
pkgver  = "2.15" 
source  = f"https://ftp.gnu.org/gnu/cpio/cpio-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []
build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && sed -e \"/^extern int (\\*xstat)/s/()/(const char * restrict, struct stat * restrict)/\" -i src/extern.h && sed -e \"/^int (\\*xstat)/s/()/(const char * restrict, struct stat * restrict)/\" -i src/global.c",
    f"cd {builddir} && ./configure --prefix=/usr --enable-mt --with-rmt=/usr/libexec/rmt",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && makeinfo --html -o doc/html doc/cpio.texi && makeinfo --html --no-split -o doc/cpio.html doc/cpio.texi && makeinfo --plaintext -o doc/cpio.txt doc/cpio.texi",
    f"cd {builddir} && make install",
    f"cd {builddir} && install -v -m755 -d /usr/share/doc/cpio-{pkgver}/html || true && install -v -m644 doc/html/* /usr/share/doc/cpio-{pkgver}/html || true && install -v -m644 doc/cpio.{{html,txt}} /usr/share/doc/cpio-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
