pkgname =  "cuda"
pkgver  = "13.0.2"
driver = "580.95.05" 
source  = f"https://developer.download.nvidia.com/compute/cuda/{pkgver}/local_installers/cuda_{pkgver}_{driver}_linux.run"
builddir = f"/tmp/fempkg/build/{pkgname}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true", 

    # 64-bit build
    f"cd {builddir} && rm -rf /opt/cuda-* || true && mkdir -pv /opt/cuda-{pkgver} || true && ln -sfv cuda-{pkgver} /opt/cuda || true",
    f"""cd {builddir} && as_root()
{{
  if   [ $EUID = 0 ];        then $*
  elif [ -x /usr/bin/sudo ]; then sudo $*
  else                            su -c \\\\"$*\\\\"
  fi
}}

export -f as_root && sh /var/lib/fempkg/pkgs/cuda_{pkgver}_{driver}_linux.run     \\
  --target cuda_{pkgver}_{driver}_linux \\
  --noexec
pushd cuda_{pkgver}_{driver}_linux/builds
  rm -rf cuda_nsight cuda_sanitizer_api nsight_{{compute,systems}}
  rm -rvf bin integration NVIDIA*.run
  as_root cp version.json /opt/cuda-{pkgver}
  as_root cp EULA.txt     /opt/cuda-{pkgver}
  rm version.json EULA.txt
  as_root mkdir -p /opt/cuda-{pkgver}/bin
  for lib in *; do
    as_root cp -vR $lib/* /opt/cuda-{pkgver}
    rm -rf $lib
  done
  as_root ln -svf lib64 /opt/cuda-{pkgver}/lib
  for mf in $(find /opt/cuda-{pkgver} -name Makefile); do
    as_root sed -i "s|/usr/local/cuda|/opt/cuda-{pkgver}|g" "$mf"
  done
popd
rm -rf cuda_{pkgver}_{driver}_linux""",
    f"""cd {builddir} && sed -e "/.*unsupported GNU version.*/d" \\
    -e "/.*unsupported clang version.*/d" \\
    -i /opt/cuda-{pkgver}/targets/x86_64-linux/include/crt/host_config.h""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
