pkgname =  "dbus-python"
pkgver  = "1.4.0" 
source  = f"https://dbus.freedesktop.org/releases/dbus-python/dbus-python-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["dbus", "glib", "meson_python", "patchelf"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --no-user dbus-python",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
