pkgname =  "dbus"
pkgver  = "1.16.2" 
source  = f"https://dbus.freedesktop.org/releases/dbus/dbus-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release --wrap-mode=nofallback -D systemd=disabled ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",
    f"cd {builddir}/build && ln -sfv /var/lib/dbus/machine-id /etc",
    
    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
