# dejagnu.recipe.py
pkgname = "dejagnu"
pkgver  = "1.6.3"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && mkdir -v build && cd build",
    f"cd /sources/{pkgname}-{pkgver}/build && ../configure --prefix=/usr",
    f"cd /sources/{pkgname}-{pkgver}/build && makeinfo --html --no-split -o doc/dejagnu.html ../doc/dejagnu.texi",
    f"cd /sources/{pkgname}-{pkgver}/build && makeinfo --plaintext -o doc/dejagnu.txt ../doc/dejagnu.texi",
    f"cd /sources/{pkgname}-{pkgver}/build && make install",

    # Install documentation
    f"cd /sources/{pkgname}-{pkgver}/build && install -v -dm755 /usr/share/doc/dejagnu-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver}/build && install -v -m644 doc/dejagnu.{{html,txt}} /usr/share/doc/dejagnu-{pkgver}",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
