pkgname =  "dosfstools"
pkgver  = "4.2" 
source  = f"https://github.com/dosfstools/dosfstools/releases/download/v{pkgver}/dosfstools-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --enable-compat-symlinks --mandir=/usr/share/man --docdir=/usr/share/doc/dosfstools-{pkgver}",
    f"cd {builddir}/ && make -j$(nproc)",
    f"cd {builddir}/ && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
