pkgname =  "dvd+rw-tools"
pkgver  = "7.1" 
source  = f"https://anduin.linuxfromscratch.org/BLFS/dvd+rw-tools/dvd+rw-tools-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cdrtools"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz && wget https://www.linuxfromscratch.org/patches/blfs/svn/dvd+rw-tools-{pkgver}-consolidated_fixes-2.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../dvd+rw-tools-{pkgver}-consolidated_fixes-2.patch",
    f"cd {builddir} && make all rpl8 btcflash -j$(nproc)",
    f"cd {builddir} && make prefix=/usr install && install -v -m644 -D index.html /usr/share/doc/dvd+rw-tools-{pkgver}/index.html",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
