pkgname =  "efibootmgr"
pkgver  = "18" 
source  = f"https://github.com/rhboot/efibootmgr/archive/{pkgver}/efibootmgr-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["efivar", "popt"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir}  || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && make EFIDIR=LFS EFI_LOADER=grubx64.efi -j$(nproc)",
    f"cd {builddir} && make install EFIDIR=LFS",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
