pkgname =  "efivar"
pkgver  = "39" 
source  = f"https://github.com/rhboot/efivar/archive/{pkgver}/efivar-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir}  || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && make ENABLE_DOCS=0 -j$(nproc)",
    f"cd {builddir} && make install ENABLE_DOCS=0 LIBDIR=/usr/lib",
    f"cd {builddir} && install -vm644 docs/efivar.1 /usr/share/man/man1 || true",
    f"cd {builddir} && install -vm644 docs/*.3 /usr/share/man/man3 || true",
    f"cd {builddir} && mv -v /etc/bash_completion.d/grub /usr/share/bash-completion/completions || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
