pkgname =  "elogind"
pkgver  = "255.17" 
source  = f"https://github.com/elogind/elogind/archive/v{pkgver}/elogind-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["dbus", "Linux-PAM",]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D man=auto -D docdir=/usr/share/doc/elogind-{pkgver} -D cgroup-controller=elogind -D dev-kvm-mode=0660 -D dbuspolicydir=/etc/dbus-1/system.d",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && ln -sfv  libelogind.pc /usr/lib/pkgconfig/libsystemd.pc || true &&  ln -sfvn elogind /usr/include/systemd || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
