pkgname = "expat"
pkgver  = "2.7.3"
source  = f"https://github.com/libexpat/libexpat/releases/download/R_2_7_3/expat-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/expat-{pkgver}",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # 32-bit build
    f"cd {builddir} && sed -e \"/^am__append_1/ s/doc//\" -i Makefile",
    f"cd {builddir} && make clean",
    f"cd {builddir} && CC=\"gcc -m32\" ./configure --prefix=/usr --disable-static --libdir=/usr/lib32 --host=i686-pc-linux-gnu",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make DESTDIR=$PWD/DESTDIR install",
    f"cd {builddir} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd {builddir} && rm -rf DESTDIR",
    

    # Cleanup
    f"rm -rf {fembuilddir}"
]
