# expect.recipe.py
pkgname = "expect"
pkgver  = "5.45.4"
source  = f"http://localhost:8080/{pkgname}{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}{pkgver} && patch -Np1 -i ../expect-{pkgver}-gcc15-1.patch",
    f"cd /sources/{pkgname}{pkgver} && ./configure --prefix=/usr --with-tcl=/usr/lib --enable-shared --disable-rpath --mandir=/usr/share/man --with-tclinclude=/usr/include",
    f"cd /sources/{pkgname}{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}{pkgver} && make install",
    f"cd /sources/{pkgname}{pkgver} && ln -svf expect5.45.4/libexpect5.45.4.so /usr/lib",


    # Cleanup
    f"rm -rf /sources/{pkgname}{pkgver}"
]
