pkgname =  "extra-cmake-modules"
pkgver  = "6.17.0" 
source  = f"https://download.kde.org/stable/frameworks/6.17/extra-cmake-modules-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "qt6"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/blfs/svn/extra-cmake-modules-{pkgver}-upstream_fix-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../extra-cmake-modules-{pkgver}-upstream_fix-1.patch && sed -i '/\"lib64\"/s/64//' kde-modules/KDEInstallDirsCommon.cmake && sed -e '/PACKAGE_INIT/i set(SAVE_PACKAGE_PREFIX_DIR \"${{PACKAGE_PREFIX_DIR}}\")' -e '/^include/a set(PACKAGE_PREFIX_DIR \"${{SAVE_PACKAGE_PREFIX_DIR}}\")' -i ECMConfig.cmake.in && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D BUILD_WITH_QT6=ON ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
