pkgname =  "eza"
pkgver  = "0.23.4" 
source  = f"https://github.com/eza-community/eza/archive/refs/tags/v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/v{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && cargo build --release",
    f"cd {builddir} && sudo install -Dm755 target/release/eza /usr/bin/eza && sudo install -Dm644 completions/fish/eza.fish /usr/share/fish/vendor_completions.d/eza.fish && sudo install -Dm644 completions/zsh/_eza /usr/share/zsh/site-functions/_eza && sudo install -Dm644 completions/bash/eza /usr/share/bash-completion/completions/eza",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
