pkgname = "fastfetch"
pkgver  = "2.53.0" 
source  = f"https://github.com/fastfetch-cli/fastfetch/archive/{pkgver}/fastfetch-{pkgver}.tar.gz"

builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
pkgfolder = f"/var/lib/fempkg/pkgs"
destdir = f"{pkgfolder}/{pkgname}-{pkgver}/DESTDIR"  # staged install here
outputdir = "/home/gabry/lfs-repo/binpkg"

deps = ["cmake"]

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf {pkgfolder}/{pkgname}-{pkgver}.tar.gz",

    # Build
    f"cd {builddir} && mkdir -p build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D BUILD_FLASHFETCH=OFF ..",
    f"cd {builddir}/build && make -j$(nproc)",

    # Staged install
    f"cd {builddir}/build && make DESTDIR={destdir} install",

    # Package
    f"mkdir -p {outputdir} && cd {destdir} && tar -I zstd -cf {outputdir}/{pkgname}-{pkgver}.tar.zst .",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir} {destdir}"
]
