pkgname =  "ffmpeg"
pkgver  = "7.1.2" 
source  = f"https://ffmpeg.org/releases/ffmpeg-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libaom", "libass", "dav1d", "SVT-AV1", "x264", "x265", "nasm", "freetype", "libvorbis", ""] #wth is libass bruv :pray: vro you could have chosen ANY name

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz && wget https://www.linuxfromscratch.org/patches/blfs/svn/ffmpeg-{pkgver}-chromium_method-1.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../ffmpeg-{pkgver}-chromium_method-1.patch && ./configure --prefix=/usr --enable-gpl --enable-version3 --enable-nonfree --disable-static --enable-shared --disable-debug --enable-libaom --enable-libass --enable-libfdk-aac --enable-libfreetype --enable-libmp3lame --enable-libopus --enable-libvorbis --enable-libvpx --enable-libx264 --enable-libx265 --enable-openssl --enable-libdav1d --enable-libsvtav1 --ignore-tests=enhanced-flv-av1,enhanced-flv-multitrack --docdir=/usr/share/doc/ffmpeg-{pkgver}",
    f"cd {builddir} && make -j$(nproc) && gcc tools/qt-faststart.c -o tools/qt-faststart",
    f"cd {builddir} && make install && install -v -m755 tools/qt-faststart /usr/bin && install -v -m755 -d /usr/share/doc/ffmpeg-{pkgver} && install -v -m644 doc/*.txt /usr/share/doc/ffmpeg-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
