pkgname =  "fftw"
pkgver  = "3.3.10" 
source  = f"https://www.fftw.org/fftw-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 1st stage
    f"cd {builddir} && ./configure --prefix=/usr --enable-shared --disable-static --enable-threads --enable-sse2 --enable-avx --enable-avx2",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",
    
    f"cd {builddir} && make clean",

    # 2st stage
    f"cd {builddir} && ./configure --prefix=/usr --enable-shared --disable-static --enable-threads --enable-sse2 --enable-avx --enable-avx2 --enable-float",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",
    
    f"cd {builddir} && make clean",

    # 3st stage
    f"cd {builddir} && ./configure --prefix=/usr --enable-shared --disable-static --enable-threads --enable-long-double",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",
    

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
