pkgname =  "flatpak"
pkgver  = "1.16.1" 
source  = f"https://github.com/flatpak/flatpak/releases/download/{pkgver}/flatpak-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["appstream", "dbus", "fuse", "glib", "gpgme", "json-glib", "elogind", "ostree", "p11-kit", "pyparsing", "libglvnd", "appstream-glib", "avahi", "bubblewrap", "curl", "libarchive", "libseccomp", "libsoup", "libxau", "xdg-dbus-proxy", "xdg-desktop-portal", "libportal"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D systemd=disabled -D system_bubblewrap=bwrap -D system_dbus_proxy=xdg-dbus-proxy -D tests=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
