# flex.recipe.py
pkgname = "flex"
pkgver  = "2.6.4"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # build & install
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --docdir=/usr/share/doc/flex-{pkgver} --disable-static",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",

    # symlinkgbb lex
    f"cd /sources/{pkgname}-{pkgver} && ln -sv flex   /usr/bin/lex",
    f"cd /sources/{pkgname}-{pkgver} && ln -sv flex.1 /usr/share/man/man1/lex.1",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
