pkgname =  "freetype"
pkgver  = "2.14.1" 
source  = f"https://downloads.sourceforge.net/freetype/freetype-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["harfbuzz", "which"]

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # Patch headers safely
    f"cd {builddir} && sed -ri 's:.*(AUX_MODULES.*valid):\\1:' modules.cfg",
    f"cd {builddir} && sed -r 's:.*(#.*SUBPIXEL_RENDERING) .*:\\1:' -i include/freetype/config/ftoption.h",
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
