pkgname =  "fuse"
pkgver  = "3.17.4" 
source  = f"https://github.com/libfuse/libfuse/releases/download/fuse-{pkgver}/fuse-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && sed -i '/^udev/,$ s/^/#/' util/meson.build  && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && chmod u+s /usr/bin/fusermount3 || true && cd .. && cp -Rv doc/html -T /usr/share/doc/fuse-{pkgver} || true && install -v -m644 doc/{{README.NFS,kernel.txt}} /usr/share/doc/fuse-{pkgver} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
