pkgname =  "fuse2"
pkgver  = "2.9.9" 
source  = f"https://github.com/libfuse/libfuse/releases/download/fuse-{pkgver}/fuse-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/fuse-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/fuse-{pkgver}.tar.gz && wget https://gitlab.archlinux.org/archlinux/packaging/packages/fuse2/-/raw/main/conditionally-define-closefrom.patch",

    # 64-bit build
    f"cd {builddir} && patch -Np1 -i ../conditionally-define-closefrom.patch && autoreconf -i -I/usr/share/gettext/m4 && ./configure --prefix=/usr --disable-static INIT_D_PATH=/tmp/init.d",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && rm -rf /tmp/init.d && install -v -m755 -d /usr/share/doc/fuse-{pkgver} && install -v -m644 doc/{{how-fuse-works,kernel.txt}} /usr/share/doc/fuse-{pkgver}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
