pkgname = "gcc"
pkgver  = "15.2.0"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # Patch multilib directories
    f"cd /sources/{pkgname}-{pkgver} && sed -e '/m64=/s/lib64/lib/' "
    f"-e '/m32=/s/m32=.*/m32=..\\/lib32$(call if_multiarch,:i386-linux-gnu)/' -i.orig gcc/config/i386/t-linux64",

    # Make -mstackrealign default for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && sed '/STACK_REALIGN_DEFAULT/s/0/(!TARGET_64BIT \\&\\& TARGET_SSE)/' -i gcc/config/i386/i386.h",

    # Make build directory
    f"cd /sources/{pkgname}-{pkgver} && mkdir -v build",

    # 64-bit + multilib configure
    f"cd /sources/{pkgname}-{pkgver}/build && export mlist=m64,m32 && "
    f"../configure --prefix=/usr LD=ld "
    f"--enable-languages=c,c++ "
    f"--enable-default-pie --enable-default-ssp --enable-host-pie "
    f"--enable-multilib --with-multilib-list=$mlist "
    f"--disable-bootstrap --disable-fixincludes --with-system-zlib",

    # Compile and install
    f"cd /sources/{pkgname}-{pkgver}/build && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver}/build && make install",

    # Fix ownership of installed headers
    f"cd /sources/{pkgname}-{pkgver}/build && "
    f"chown -v -R root:root /usr/lib/gcc/$(gcc -dumpmachine)/{pkgver}/include{{,-fixed}}",

    # Create required symlinks
    f"cd /sources/{pkgname}-{pkgver}/build && ln -svr /usr/bin/cpp /usr/lib || true",
    f"cd /sources/{pkgname}-{pkgver}/build && ln -sv gcc.1 /usr/share/man/man1/cc.1 || true",
    f"cd /sources/{pkgname}-{pkgver}/build && "
    f"ln -sfv ../../libexec/gcc/$(gcc -dumpmachine)/{pkgver}/liblto_plugin.so /usr/lib/bfd-plugins/ || true",

    # Move GDB auto-load files
    f"cd /sources/{pkgname}-{pkgver}/build && mkdir -pv /usr/share/gdb/auto-load/usr/lib || true",
    f"cd /sources/{pkgname}-{pkgver}/build && mv -v /usr/lib/*gdb.py /usr/share/gdb/auto-load/usr/lib || true",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
