pkgname =  "gcr"
pkgver  = "3.41.2" 
source  = f"https://download.gnome.org/sources/gcr/3.41/gcr-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "libgcrypt", "p11-kit", "gpg", "gtk4", "libsecret", "vala"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed '/ssh.add/d; /ssh.agent/d' -i meson.build && sed -i 's:\"/desktop:\"/org:' schema/*.xml && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D gtk_doc=false -D ssh_agent=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
