pkgname =  "gdkpixbuf"
pkgver  = "2.44.2" 
source  = f"https://download.gnome.org/sources/gdk-pixbuf/2.44/gdk-pixbuf-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/gdk-pixbuf-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["glib", "libjpegturbo", "libpng", "shared-mime-info", "libtiff"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/gdk-pixbuf-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D others=enabled -D glycin=disabled --wrap-mode=nofallback",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
