pkgname =  "geoclue"
pkgver  = "2.8.0" 
source  = f"https://gitlab.freedesktop.org/geoclue/geoclue/-/archive/{pkgver}/geoclue-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["json-glib", "libsoup", "libnotify", "vala", "ModemManager"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D gtk-doc=false -D nmea-source=false ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",
    f"""cat > /etc/geoclue/conf.d/90-lfs-google.conf << "EOF"
# Begin /etc/geoclue/conf.d/90-lfs-google.conf

# This configuration applies for the WiFi source.
[wifi]

# Set the URL to Google's Geolocation Service.
url=https://www.googleapis.com/geolocation/v1/geolocate?key=AIzaSyCmBCAAwwSjPLqFOuQjDV2g7mkQmv2kiTs

# End /etc/geoclue/conf.d/90-lfs-google.conf
EOF""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
